Graphics 800,600,16,2

Dim basicTriangle(1,4) ; x and y, points for the shapes
Dim newShape(1,4) ; rotated points for the basic triangle, used when a triangle needs rotation
Dim rotationSteps(6) ; steps per workable rotation

; pre set rotations to be applied to a shape
rotationSteps(0)=0
rotationSteps(1)=60
rotationSteps(2)=120
rotationSteps(3)=180
rotationSteps(4)=240
rotationSteps(5)=300

; triangle width and height (changeing the triangle size also means making a new play board image)
Global twidth=14*2
Global theight=12*2

Global shapeCnt=23 ; total number of shapes +1

; field width and height
Global fieldcols=35 ; longest horizontal line is 35 triangles long
Global fieldrows=17 ; 18 lines verticaly

Global levelColR=50,levelColG=50,levelColB=50

; shape triangle count array
Dim shapeTriangleCnt(shapeCnt)  ; per shape, a total triangle count is needed to plot the shape
Dim shapeTileCnt(shapeCnt)

; shape 0 is the entire field with the most triangles used to for the shape
shapeTriangleCnt(0)=(fieldcols+1)*(fieldrows+1)

Dim playfield(shapeTriangleCnt(0)) ; tile status (-2 is not usable, -1 is empty, 0 is player 0, 1 is player 1 2 and 3 is player 2 and 3)

; shapes array
Dim shapes(shapeCnt,shapeTriangleCnt(0),3) ; shape nr, triangle nr, triangle x pos and y pos and rotation value of a triangle to build a shape

Dim playerShapesCnt(shapeCnt) ; number of shapes per player (array number matches shape number)

createSingleTriangle()
createShapes()

; game sprites
Global gameSprites=LoadImage("..\img_metal\stones.png")
MaskImage gameSprites,58,60,57

; set play field drawing offset
fieldOffsetx=twidth/2+20
fieldOffsety=theight/2+20

;---------------------------------------- end of standard game stuf, start of designer stuf -------------------------

Global currentLevel=0

Global levelfile$=""

Global levelbackgrnds, levelScoreLevel


loadLevel()

SetBuffer BackBuffer()

While Not keyPressed=27

	keyPressed=GetKey()
	mx=MouseX()
	my=MouseY()
	button=GetMouse() ; but nr that is pressed
	
	Select keyPressed
	
		Case Asc("s")
			saveLevel()

		Case Asc("l")
			loadLevel()

		Case Asc(".")
			currentLevel=currentLevel+1
			loadLevel()

		Case Asc(",")
			currentLevel=currentLevel-1
			loadLevel()

		Case Asc("=")
			levelScoreLevel=levelScoreLevel+1

		Case Asc("-")
			levelScoreLevel=levelScoreLevel-1

		Case Asc("r")
			levelColR=(levelColR+1) Mod 256

		Case Asc("g")
			levelColG=(levelColG+1) Mod 256

		Case Asc("b")
			levelColB=(levelColB+1) Mod 256
			
	End Select
	
	Cls
	
	DrawImageRect levelbackgrnds,30,26,0,0,515,442
	
	titles=0
	
	For t=0 To shapeTriangleCnt(0)-1
		Color levelColR,levelColG,levelColB
	
		calcTriangle(shapes(0,t,2),shapes(0,t,0),shapes(0,t,1),0,0)	
	
		If playfield(t)=-1  ; if field item is used (0=field itself, -1 is field point that can't be used)
		
			titles=titles+1
			drawTriangle(fieldOffsetx,fieldOffsety)
		
		Else If playfield(t)>-1
			spriteNum=playfield(t)
		
			drawGameIcon(fieldOffsetx,fieldOffsety,shapes(0,t,2),spriteNum)
		
		Else
			drawGameIcon(fieldOffsetx,fieldOffsety,shapes(0,t,2),playfield(t))
		
		End If
		
	Next

	Color 255,50,255

	Text 10,12, "Level: "+currentLevel + " Open Tiles: "+titles+" Level score:"+levelScoreLevel + " Color:"+levelColR+","+levelColG+","+levelColB

	nx=(mx-fieldOffsetx)/(twidth/2)
	ny=(my-fieldOffsety)/theight

	tx=nx*(twidth/2)+fieldOffsetx
	ty=ny*theight+fieldOffsety


	centerX=(tx-fieldOffsetx)/(twidth/2)
	centerY=(ty-fieldOffsety)/theight

	fieldarrPos=-1

	If (centerX>0 And centerX<=fieldcols And centerY>-1 And centerY<=fieldrows And my>=fieldOffsety)

		Color 255,128,255
		Oval tx-2,ty+10,5,5,1
	
		Color 20,0,0
		
		Oval tx-2,ty+10,6,6,0
	
		Color 255,0,0

		; calc array position
		ex=centerY Mod 2
		
		fieldarrPos = (centerX-ex)+centerY*(fieldcols+1) 

		Select button
		Case 1
			playfield(fieldarrPos)=playfield(fieldarrPos)+1
		Case 2
			playfield(fieldarrPos)=playfield(fieldarrPos)-1
		End Select 

		Color 255,50,255

		Text 10,24, "Field info: "+fieldarrPos+ " " + playfield(fieldarrPos)

	End If

	totalc=0

	For t=1 To 22
		Text 10,24+t*12,playerShapesCnt(t)+1 + " " + (shapeTileCnt(t-1)*(playerShapesCnt(t)+1))
	
		totalc=totalc+(shapeTileCnt(t-1)*(playerShapesCnt(t)+1))
	
		If my>24+t*12 And my<24+(t+1)*12 And mx>10 And mx<22
			Select button
				Case 1
					playerShapesCnt(t)=playerShapesCnt(t)+1
				
				Case 2
					playerShapesCnt(t)=playerShapesCnt(t)-1
			End Select
		End If
	Next
	
	Text 10,24+24*12,totalc

	Flip(True)
Wend


End

Function calcTriangle(angle,offsetx,offsety,angleX,angleY)

	; rotate the offset x and y of the shape
	roffsetx = offsetx * Cos(angle) - offsety * Sin(angle)
	roffsety = offsetx * Sin(angle) + offsety * Cos(angle)	

	; rotate the triangle	
	For cnt=0 To 3
		newShape(0,cnt) = basicTriangle(0,cnt) * Cos(angle) - basicTriangle(1,cnt) * Sin(angle)
		newShape(1,cnt) = basicTriangle(0,cnt) * Sin(angle) + basicTriangle(1,cnt) * Cos(angle)
		
		newShape(0,cnt) = newShape(0,cnt)+roffsetx
		newShape(1,cnt) = newShape(1,cnt)+roffsety
	
		;rot over x ax
		newShape(0,cnt) = newShape(0,cnt) * Cos(angleY)
		
		; rot over y ax
		newShape(1,cnt) = newShape(1,cnt) * Cos(angleX)		
	
	Next
End Function


Function drawTriangle(screenposx,screenposy)
	; draw all the lines for the triangle
	For c=0 To 2 ; stop at 2 because the line adds 1 to make 2 points (+1 for end point)
		Line newShape(0,c)+screenposx,newShape(1,c)+screenposy,newShape(0,c+1)+screenposx,newShape(1,c+1)+screenposy
	Next
End Function

Function createSingleTriangle()
	; single triangle coordinates, used for all other triangles
	
	basicTriangle(0,0)=0
	basicTriangle(1,0)=0
	
	basicTriangle(0,1)=twidth
	basicTriangle(1,1)=0
	
	basicTriangle(0,2)=twidth/2
	basicTriangle(1,2)=theight
	
	basicTriangle(0,3)=0
	basicTriangle(1,3)=0
End Function


Function createShapes()
	; first shape is the field itself
	
	For r=0 To fieldrows
	
		f=r Mod 2
	
		For t=0 To fieldcols
			
			If t Mod 2=0 ; tile must be upside up
			
				shapes(0,t+r*(fieldcols+1),0)=twidth*(t/2)-twidth/2+(f*twidth/2)
				shapes(0,t+r*(fieldcols+1),1)=theight*r
				shapes(0,t+r*(fieldcols+1),2)=0
			Else ; tile must be upside down

				shapes(0,t+r*(fieldcols+1),0)=-twidth*(t/2)-twidth-(f*twidth/2)
				shapes(0,t+r*(fieldcols+1),1)=-theight*(r+1)
				shapes(0,t+r*(fieldcols+1),2)=180

			End If	
	
		Next	
	Next
	
	playerShapesCnt(0)=-1
	
	setShapeTileCnt()
		
End Function


Function drawGameIcon(fieldOffsetx,fieldOffsety,shapeAngle, iconNum)

	;drawTriangle(fieldOffsetx,fieldOffsety)

	centerX=((newShape(0,0)+newShape(0,1)+newShape(0,2))/3+fieldOffsetx)
	centerY=((newShape(1,0)+newShape(1,1)+newShape(1,2))/3+fieldOffsety)

	spriteNum=0

	Select iconNum

		Case 0
			spriteNum=1
		Case 1
			spriteNum=2
		Case 2
			spriteNum=3
		Case 3
			spriteNum=4

		Case 4
			spriteNum=5
		Case 5
			spriteNum=6
		Case 6
			spriteNum=7

	End Select

	If spriteNum>-1
	
		If shapeAngle<>0
			centerX=centerX-12
			centerY=centerY-15
	
			; triangle pointing up
			DrawImageRect gameSprites,centerX,centerY, 1,spriteNum*24+1, 25,23
		Else
			centerX=centerX-12
			centerY=centerY-8
	
			; triangle pointing down
			DrawImageRect gameSprites,centerX,centerY, 27,spriteNum*24+1, 25,23
		
		End If
;	Else
		Text centerX+6,centerY+4,iconNum
	End If
		
End Function


Function loadLevel()
	; load the level picture filename
	; load the amount of shapes for this level
	
	filein = ReadFile("..\data\level"+currentLevel+".dat")

	If Not filein
	filein = ReadFile("..\data\level0.dat")
	
	End If
	
	For t=0 To shapeTriangleCnt(0)-1
		; load the playfield array values here
		playfield(t)=ReadInt( filein ) 
	Next

	levelfile$=ReadString(filein)

	For t=1 To 22
		playerShapesCnt(t)=ReadInt( filein)
	Next

	levelColR=ReadByte(filein)
	levelColG=ReadByte(filein)
	levelColB=ReadByte(filein)

	levelScoreLevel=ReadInt( filein)

	CloseFile(filein)

	; load the level background picture
	levelbackgrnds = LoadImage("..\img_metal\"+levelfile)
	MaskImage levelbackgrnds ,49,49,49

End Function

Function saveLevel()
	fileout = WriteFile("..\data\level"+currentLevel+".dat")

	For t=0 To shapeTriangleCnt(0)-1
		; save the playfield array values here
		WriteInt( fileout, playfield(t) ) 
	Next

	; save the level picture filename
	WriteString(fileout,"level"+currentLevel+".png")

	; save the amount of shapes for this level	
	For t=1 To 22
		WriteInt( fileout, playerShapesCnt(t)) 	
	Next

	WriteByte(fileout,levelColR)
	WriteByte(fileout,levelColG)
	WriteByte(fileout,levelColB)

	WriteInt( fileout,levelScoreLevel)

	CloseFile(fileout)
	
End Function

Function setShapeTileCnt()
	; amount of tile on a shape

	shapeTileCnt(0)=1
	shapeTileCnt(1)=2
	shapeTileCnt(2)=6
	shapeTileCnt(3)=3
	shapeTileCnt(4)=3
	shapeTileCnt(5)=4
	shapeTileCnt(6)=5
	shapeTileCnt(7)=6
	shapeTileCnt(8)=6
	shapeTileCnt(9)=6
	shapeTileCnt(10)=5
	shapeTileCnt(11)=4
	shapeTileCnt(12)=5
	shapeTileCnt(13)=6
	shapeTileCnt(14)=5
	shapeTileCnt(15)=6
	shapeTileCnt(16)=6
	shapeTileCnt(17)=6
	shapeTileCnt(18)=6
	shapeTileCnt(19)=6
	shapeTileCnt(20)=6
	shapeTileCnt(21)=6

End Function